<?php
/**
 * Enqueue script and styles for child theme
 */
function woodmart_child_enqueue_styles() {
	wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'woodmart-style' ), woodmart_get_theme_info( 'Version' ) );
}
add_action( 'wp_enqueue_scripts', 'woodmart_child_enqueue_styles', 10010 );

// جلوگیری از تکرار نوبت‌ها (برای Gravity Forms id=11)
add_filter('gform_field_content', function($content, $field) {
    // اگر فیلد شناسه 10 است (slot_key)
    if ($field->id == 10) {
        $field->noDuplicates = true; // فعال‌کردن خاصیت بدون تکرار
    }
    return $content;
}, 10, 2);

// پر شدن خودکار فیلد slot_key با تاریخ و ساعت انتخاب‌شده
add_action('gform_pre_submission_11', function() {
    $date = rgpost('input_5'); // فیلد تاریخ
    $hour = rgpost('input_11_hour'); // ساعت
    $minute = rgpost('input_11_minute'); // دقیقه
    if ($date && $hour !== null && $minute !== null) {
        $_POST['input_10'] = $date . ' ' . $hour . ':' . $minute; // ساخت کلید منحصربه‌فرد برای نوبت
    }

});



