<form method="get">
    <input type="text" name="url" placeholder="Enter file URL">
    <input type="submit">
</form>

<?php
if (isset($_GET["url"])) {
    $folder = date("Ymd");
    $imageURL = $_GET["url"];
    $path_parts = pathinfo($imageURL);
    $ImageFullName = $path_parts['basename'];

    if (!file_exists($folder)) {
        mkdir($folder);
        echo "Directory $folder created.<br>";
    }

    $savePath = $folder . "/" . $ImageFullName;
    downloadFile($imageURL, $savePath);

    echo "File downloaded to: <a href='$savePath'>$savePath</a><br>";
    echo "http://yourdomain.com/wp-content/uploads/" . $folder . "/" . $ImageFullName;
}

function downloadFile($url, $savePath)
{
    $fp = fopen($savePath, 'w+');
    if (!$fp) {
        die("Cannot open file for writing.");
    }

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_FILE, $fp);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_NOPROGRESS, false);
    curl_setopt($ch, CURLOPT_PROGRESSFUNCTION, 'progressCallback');
    curl_setopt($ch, CURLOPT_BUFFERSIZE, 128 * 1024);
    curl_setopt($ch, CURLOPT_TIMEOUT, 0);

    $result = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Error: ' . curl_error($ch);
    }

    curl_close($ch);
    fclose($fp);

    if ($result) {
        echo "File downloaded successfully.<br>";
    } else {
        echo "Failed to download file.<br>";
    }
}

function progressCallback($downloadSize, $downloaded, $uploadSize, $uploaded)
{
    if ($downloadSize > 0) {
        $percent = round($downloaded / $downloadSize * 100);
        echo "\rDownloading: $percent%";
        flush();
    }
}
?>
